/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1.graphics;

import com.roguewave.chart.core.v2_1.graphics.Point3D;
import java.io.Serializable;

public class Transform3D
implements Serializable {
    private double a_;
    private double b_;
    private double c_;
    private double d_;
    private double e_;
    private double f_;
    private double g_;
    private double h_;
    private double i_;
    private double j_;
    private double k_;
    private double m_;
    private double q_;
    private double r_;
    private boolean isPer_ = false;

    public Transform3D() {
        this.r_ = 1.0;
        this.k_ = 1.0;
        this.f_ = 1.0;
        this.a_ = 1.0;
        this.q_ = 0.0;
        this.m_ = 0.0;
        this.j_ = 0.0;
        this.i_ = 0.0;
        this.h_ = 0.0;
        this.g_ = 0.0;
        this.e_ = 0.0;
        this.d_ = 0.0;
        this.c_ = 0.0;
        this.b_ = 0.0;
    }

    public Transform3D(Transform3D transform3D, Transform3D transform3D2) {
        this.a_ = transform3D.a_ * transform3D2.a_ + transform3D.b_ * transform3D2.e_ + transform3D.c_ * transform3D2.i_;
        this.b_ = transform3D.a_ * transform3D2.b_ + transform3D.b_ * transform3D2.f_ + transform3D.c_ * transform3D2.j_;
        this.c_ = transform3D.a_ * transform3D2.c_ + transform3D.b_ * transform3D2.g_ + transform3D.c_ * transform3D2.k_ + transform3D.d_ * transform3D2.q_;
        this.d_ = transform3D.a_ * transform3D2.d_ + transform3D.b_ * transform3D2.h_ + transform3D.c_ * transform3D2.m_ + transform3D.d_;
        this.e_ = transform3D.e_ * transform3D2.a_ + transform3D.f_ * transform3D2.e_ + transform3D.g_ * transform3D2.i_;
        this.f_ = transform3D.e_ * transform3D2.b_ + transform3D.f_ * transform3D2.f_ + transform3D.g_ * transform3D2.j_;
        this.g_ = transform3D.e_ * transform3D2.c_ + transform3D.f_ * transform3D2.g_ + transform3D.g_ * transform3D2.k_ + transform3D.h_ * transform3D2.q_;
        this.h_ = transform3D.e_ * transform3D2.d_ + transform3D.f_ * transform3D2.h_ + transform3D.g_ * transform3D2.m_ + transform3D.h_;
        this.i_ = transform3D.i_ * transform3D2.a_ + transform3D.j_ * transform3D2.e_ + transform3D.k_ * transform3D2.i_;
        this.j_ = transform3D.i_ * transform3D2.b_ + transform3D.j_ * transform3D2.f_ + transform3D.k_ * transform3D2.j_;
        this.k_ = transform3D.i_ * transform3D2.c_ + transform3D.j_ * transform3D2.g_ + transform3D.k_ * transform3D2.k_ + transform3D.m_ * transform3D2.q_;
        this.m_ = transform3D.i_ * transform3D2.d_ + transform3D.j_ * transform3D2.h_ + transform3D.k_ * transform3D2.m_ + transform3D.m_;
        this.q_ = transform3D.q_ * transform3D2.k_;
        this.r_ = transform3D.q_ * transform3D2.m_ + transform3D.r_ * transform3D2.r_;
    }

    public Point3D transform(Point3D point3D) {
        double d = point3D.x_;
        double d2 = point3D.y_;
        double d3 = point3D.z_;
        if (this.isPer_) {
            double d4 = this.q_ * d3;
            if (d4 == 0.0) {
                System.err.println("Transform3D.transform(" + point3D + ") -> w == 0\n" + this + "\n");
            }
            return new Point3D(d / d4, d2 / d4, d3 / d4);
        }
        double d5 = this.a_ * d + this.b_ * d2 + this.c_ * d3 + this.d_;
        double d6 = this.e_ * d + this.f_ * d2 + this.g_ * d3 + this.h_;
        double d7 = this.i_ * d + this.j_ * d2 + this.k_ * d3 + this.m_;
        return new Point3D(d5, d6, d7);
    }

    public static Transform3D product(Transform3D transform3D, Transform3D transform3D2) {
        return new Transform3D(transform3D, transform3D2);
    }

    public static Transform3D scale(double d, double d2, double d3) {
        Transform3D transform3D = new Transform3D();
        transform3D.a_ = d;
        transform3D.f_ = d2;
        transform3D.k_ = d3;
        return transform3D;
    }

    public static Transform3D translate(double d, double d2, double d3) {
        Transform3D transform3D = new Transform3D();
        transform3D.d_ = d;
        transform3D.h_ = d2;
        transform3D.m_ = d3;
        return transform3D;
    }

    public static Transform3D rotateX(double d) {
        double d2 = d * Math.PI / 180.0;
        Transform3D transform3D = new Transform3D();
        transform3D.k_ = transform3D.f_ = Math.cos(d2);
        transform3D.j_ = Math.sin(d2);
        transform3D.g_ = -transform3D.j_;
        return transform3D;
    }

    public static Transform3D rotateY(double d) {
        double d2 = d * Math.PI / 180.0;
        Transform3D transform3D = new Transform3D();
        transform3D.k_ = transform3D.a_ = Math.cos(d2);
        transform3D.i_ = Math.sin(d2);
        transform3D.c_ = -transform3D.i_;
        return transform3D;
    }

    public static Transform3D rotateZ(double d) {
        double d2 = d * Math.PI / 180.0;
        Transform3D transform3D = new Transform3D();
        transform3D.f_ = transform3D.a_ = Math.cos(d2);
        transform3D.e_ = Math.sin(d2);
        transform3D.b_ = -transform3D.e_;
        return transform3D;
    }

    public static Transform3D rotateZNeg90Degrees() {
        Transform3D transform3D = new Transform3D();
        transform3D.f_ = 0.0;
        transform3D.a_ = 0.0;
        transform3D.e_ = -1.0;
        transform3D.b_ = 1.0;
        return transform3D;
    }

    public static Transform3D shear(double d) {
        Transform3D transform3D = new Transform3D();
        transform3D.c_ = d;
        transform3D.g_ = d;
        return transform3D;
    }

    public static Transform3D shear(double d, double d2) {
        Transform3D transform3D = new Transform3D();
        transform3D.c_ = d;
        transform3D.g_ = d2;
        return transform3D;
    }

    public static Transform3D perspective(double d) {
        Transform3D transform3D = new Transform3D();
        transform3D.q_ = 1.0 / d;
        transform3D.r_ = 0.0;
        transform3D.isPer_ = true;
        return transform3D;
    }

    public String toString() {
        return "[ " + this.a_ + " " + this.b_ + " " + this.c_ + " " + this.d_ + " ]\n" + "[ " + this.e_ + " " + this.f_ + " " + this.g_ + " " + this.h_ + " ]\n" + "[ " + this.i_ + " " + this.j_ + " " + this.k_ + " " + this.m_ + " ]\n" + "[ 0 0 " + this.q_ + " " + this.r_ + " ]";
    }
}

